(function($){
	"use-strict";

	$(document).ready(function() {
		edgtfInitSelectChange();
	});
	
	$(window).load(function() {
		edgtfShowHidePostFormatsGutenberg();
	});

	function edgtfInitSelectChange() {
		$(document).on('change', 'select.dependence', function (e) {
			var optionSelected = $("option:selected", this);
			var valueSelected = this.value.replace(/ /g, '');
			$($(this).data('hide-'+valueSelected)).fadeOut();
			$($(this).data('show-'+valueSelected)).fadeIn();
		});
	}
	
	function edgtfShowHidePostFormatsGutenberg() {
		var gutenbergEditor = $('.block-editor__container');
		
		if(gutenbergEditor.length) {
			var gPostFormatField = gutenbergEditor.find('.editor-post-format');
			
			gPostFormatField.find('select option').each(function () {
				$('#edgtf-meta-box-post-format-' + $(this).val()).hide();
			});
			
			if (gPostFormatField.find('select option:selected')) {
				$('#edgtf-meta-box-post-format-' + gPostFormatField.find('select option:selected').val()).fadeIn();
			}
			
			gPostFormatField.find('select').change(function(){
				edgtfShowHidePostFormatsGutenberg();
			});
		}
	}
})(jQuery);
